% demo script to make an automatically labeled contour plot using from a 
% contour data file generated by the Perple_X program WERAMI, for 
% data file format see: 
% www.perplex.ethz.ch/perplex/special/README_WERAMI_GRID_FORMAT.txt
% JADC 3/3/04

% code to read werami plot file contributed by Philippe Goncalves, U.
% Amherst, 2/26/04

clear all;
clf;

%                                  open werami ascii file
data_file=uigetfile('c*pl*', 'select grid contour file (generated by werami)');
enter = fopen(data_file, 'rt');
filename = fscanf(enter, '%s', 1);

nx = fscanf(enter, '%f', 1);           
ny = fscanf(enter, '%f', 1);
xmin = fscanf(enter, '%f', 1);
ymin = fscanf(enter, '%f', 1);
xinc = fscanf(enter, '%f', 1);
yinc = fscanf(enter, '%f', 1);
xname = fscanf(enter, '%s', 1);
yname = fscanf(enter, '%s', 1);
fclose(enter);

a = textread(data_file, '%f','headerlines',4);
b = reshape(a,nx,ny);
c = fliplr (b);
d = rot90 (c);

x = xmin:xinc:xmin+(nx-1)*xinc;     % create a vector argument of 250 from xmin to xmax witih a nx increment
y = ymin:yinc:ymin+(ny-1)*yinc;     % create a vector argument of 250 from ymin to ymax witih a ny increment

                                    % get contour intervals:
dmin = min(d(:));
dmax = max(d(:));
disp(['Grid data range is ',num2str(dmin),' - >',num2str(dmax)])
%cmin=input('Enter min contour:');
%cmax=input('Enter max contour:');
%cinc=input('Enter contour interval:');
%contours = [cmin:cinc:cmax];

figure (2);
%[C,h]=contour(x,y,d,contours);axis tight;xlabel(xname); ylabel(yname);clabel(C,h);
[C,h]=contour(x,y,d);axis tight;xlabel(xname); ylabel(yname);clabel(C,h);
title ('automatically labeled plot')
