% script to plot ratio of values from two WERAMI output files,
% files must have consistent dimensions.

%                                   M Caddick, March 25, 2006

clear all;
clf;
warning off MATLAB:divideByZero;

%                                  open werami numerator file
data_file=uigetfile('c*pl*', 'select NUMERATOR file (generated by werami)');
enter = fopen(data_file, 'rt');
filename = fscanf(enter, '%s', 1);

nx = fscanf(enter, '%f', 1);           
ny = fscanf(enter, '%f', 1);
xmin = fscanf(enter, '%f', 1);
ymin = fscanf(enter, '%f', 1);
xinc = fscanf(enter, '%f', 1);
yinc = fscanf(enter, '%f', 1);
xname = fscanf(enter, '%s', 1);
yname = fscanf(enter, '%s', 1);
fclose(enter);

disp(['Caluclating plot of ',data_file]);

a = textread(data_file, '%f','headerlines',4);

%                                  open werami denominator file
data_file=uigetfile('c*pl*', 'select DENOMINATOR file (generated by werami)');
enter = fopen(data_file, 'rt');
filename = fscanf(enter, '%s', 1);

nx1 = fscanf(enter, '%f', 1);           
ny1 = fscanf(enter, '%f', 1);
xmin1 = fscanf(enter, '%f', 1);
ymin1 = fscanf(enter, '%f', 1);
xinc1 = fscanf(enter, '%f', 1);
yinc1 = fscanf(enter, '%f', 1);
xname1 = fscanf(enter, '%s', 1);
yname1 = fscanf(enter, '%s', 1);
fclose(enter);

disp(['        divided by ',data_file]);
disp([' ']);

if(nx~=nx1 | ny~=ny1 | xmin~=xmin1 | ymin~=ymin1 | xinc~=xinc1 | yinc~=yinc1)
    disp(['Files not equivalent. You be screwed']);
    return;
end

a1 = textread(data_file, '%f','headerlines',4);

%                                  divide numerator by denominator, then
%                                  replace infinite values with zero and
%                                  reshape array
a=a./a1;
a(find(a==Inf))=0;

b = reshape(a,nx,ny);
c = fliplr (b);
d = rot90 (c);

%                                  Display temp in C or K, and pressure in
%                                  GPa or bars

tempscale=1;
if(tempscale==1)
    xmin=xmin-273;
    xname='Temp, C';
    disp(['Temperature scale set to: CELSIUS']);
else
    disp(['Temperature scale set to: KELVIN']);    
end
pressurescale=1;
if(pressurescale==1)
    ymin=(ymin/10000);
    yinc=(yinc/10000);
    yname='Pressure, GPa';
    disp(['Pressure scale set to: GPa']);
else
    disp(['Pressure scale set to: bars']);
end
disp([' ']);


x = xmin:xinc:xmin+(nx-1)*xinc;     % create a vector argument of 250 from xmin to xmax witih a nx increment
y = ymin:yinc:ymin+(ny-1)*yinc;     % create a vector argument of 250 from ymin to ymax witih a ny increment


% get contour intervals:
dmin = min(d(:));
dmax = max(d(:));
disp(['Grid data range is ',num2str(dmin),' - >',num2str(dmax)])
cmin=input('Enter min contour:');
cmax=input('Enter max contour:');
cinc=input('Enter contour interval:');
contours = [cmin:cinc:cmax];


figure (3);
[C,h]=contour(x,y,d,contours);axis tight;xlabel(xname); ylabel(yname);clabel(C,h,'manual');
title ('As drawn with MATLAB by MJC...');
