% a crude matlab script to make 3D surface plots of two grid files generated 
% by werami with geotherms superimposed.

% this script is intended only as a demo, the output created by this script is
% at:

% www.perplex.ethz.ch/images/metabasalt_CO2_and_water_content.jpg


figure(1);

%                                  open first werami ascii file
data_file=uigetfile('c*pl*', 'select grid contour file (generated by werami)');
enter = fopen(data_file, 'rt');
filename = fscanf(enter, '%s', 1);

nx = fscanf(enter, '%f', 1);           
ny = fscanf(enter, '%f', 1);
xmin = fscanf(enter, '%f', 1);
ymin = fscanf(enter, '%f', 1);
xinc = fscanf(enter, '%f', 1);
yinc = fscanf(enter, '%f', 1);
xname = fscanf(enter, '%s', 1);
yname = fscanf(enter, '%s', 1);
fclose(enter);

y = ymin:yinc:ymin+(ny-1)*yinc;
x = xmin:xinc:xmin+(nx-1)*xinc;
%              get geotherm coordinates
% cold
p1 = -207889.  + 1076.4438*x  -1.74443*x.^2 + 0.000979551  *x.^3;

% med 

p2 = -171680. + 747.5574808*x -1.033447174 *x.^2 + 0.000503665 *x.^3;

% hot

p3 = -156257. + 595.6523*x -0.72823*x.^2 +  0.000314799 *x.^3;

imax = max(find(p1<ymin+(ny-1)*yinc));
imin = min(find(p1>ymin));
ind1 = imin:1:imax;
imax = max(find(p2<ymin+(ny-1)*yinc));
imin = min(find(p2>ymin));
ind2 = imin:1:imax;
imax = max(find(p3<ymin+(ny-1)*yinc));
imin = min(find(p3>ymin));
ind3 = imin:1:imax;

b = textread(data_file, '%f','headerlines',4);
d = reshape(b,ny,nx);

hg1 = interp2(x,y,d,x,p1);
hg2 = interp2(x,y,d,x,p2);
hg3 = interp2(x,y,d,x,p3);

zg1 = p1/330;
zg2 = p2/330;
zg3 = p3/330;

tc = x - 273;
z = y/330;


dmin = min(d(:));
dmax = max(d(:));
disp(['Grid data range is ',num2str(dmin),' - >',num2str(dmax)])

%subplot (2,2,1)
subplot('position',[0.05,0.32,0.42,0.50])
light
lighting phong
surf(tc,z,d);shading interp;lighting phong;axis tight;
axis ij
view(45,60)
%colorbar;
title ('Staudigel Metabasalt H_2O content')
xlabel('Temperature, ^oC')
ylabel('Depth, km')
zlabel('Weight % H_{2}O')
hold on
plot3(tc(ind1),zg1(ind1),hg1(ind1),'y',tc(ind2),zg2(ind2),hg2(ind2),'r',tc(ind3),zg3(ind3),hg3(ind3),'y','linewidth',5)




%                                  open second werami ascii file
data_file=uigetfile('c*pl*', 'select grid contour file (generated by werami)');
enter = fopen(data_file, 'rt');
filename = fscanf(enter, '%s', 1);

nx = fscanf(enter, '%f', 1);           
ny = fscanf(enter, '%f', 1);
xmin = fscanf(enter, '%f', 1);
ymin = fscanf(enter, '%f', 1);
xinc = fscanf(enter, '%f', 1);
yinc = fscanf(enter, '%f', 1);
xname = fscanf(enter, '%s', 1);
yname = fscanf(enter, '%s', 1);
fclose(enter);

y = ymin:yinc:ymin+(ny-1)*yinc;
x = xmin:xinc:xmin+(nx-1)*xinc;
%              get geotherm coodinates
% cold
p1 = -207889.  + 1076.4438*x  -1.74443*x.^2 + 0.000979551  *x.^3;

% med 

p2 = -171680. + 747.5574808*x -1.033447174 *x.^2 + 0.000503665 *x.^3;

% hot

p3 = -156257. + 595.6523*x -0.72823*x.^2 +  0.000314799 *x.^3;

b = textread(data_file, '%f','headerlines',4);
d = reshape(b,ny,nx);

hg1 = interp2(x,y,d,x,p1);
hg2 = interp2(x,y,d,x,p2);
hg3 = interp2(x,y,d,x,p3);

zg1 = p1/330;
zg2 = p2/330;
zg3 = p3/330;

tc = x - 273;
z = y/330;


dmin = min(d(:));
dmax = max(d(:));
disp(['Grid data range is ',num2str(dmin),' - >',num2str(dmax)])

%subplot (2,2,2)
subplot('position',[0.55,0.32,0.42,0.50])
light
lighting phong
surf(tc,z,d);shading interp;lighting phong;axis tight;
axis ij
%colorbar;
view(45,60)
title ('Staudigel Metabasalt CO_2 content')
xlabel('Temperature, ^oC')
ylabel('Depth, km')
zlabel('Weight % CO_{2}')
hold on
plot3(tc(ind1),zg1(ind1),hg1(ind1),'y',tc(ind2),zg2(ind2),hg2(ind2),'r',tc(ind3),zg3(ind3),hg3(ind3),'y','linewidth',5)


