% demo script to make a 3D surface plot using from a contour data file
% generated by the Perple_X program WERAMI, for data file format see 
% www.perplex.ethz.ch/perplex/special/README_WERAMI_GRID_FORMAT.txt

% code to read werami plot file contributed by Philippe Goncalves, U.
% Amherst, 2/26/04

clear all;
clf;

%open werami ascii file

data_file=uigetfile('c*pl*', 'select grid contour file (generated by werami)');
enter = fopen(data_file, 'rt');

filename = fscanf(enter, '%s', 1);
nx = fscanf(enter, '%f', 1);           
ny = fscanf(enter, '%f', 1);
xmin = fscanf(enter, '%f', 1);
ymin = fscanf(enter, '%f', 1);
xinc = fscanf(enter, '%f', 1);
yinc = fscanf(enter, '%f', 1);
xname = fscanf(enter, '%s', 1);
yname = fscanf(enter, '%s', 1);
fclose(enter);

a = textread(data_file, '%f','headerlines',4);
b = reshape(a,nx,ny);
c = fliplr (b);
d = rot90 (c);

% uncomment the following lines to filter data

%val = input('Enter upper shoe size value ')
%ind = find(d>=val);
%d(ind) = val;
%val = input('Enter lower shoe size value ')
%ind = find(d<=val);
%d(ind) = val;

x = xmin:xinc:xmin+(nx-1)*xinc;     % create a vector argument of 250 from xmin to xmax witih a nx increment
y = ymin:yinc:ymin+(ny-1)*yinc;     % create a vector argument of 250 from ymin to ymax witih a ny increment

%                                     3D plot with phong lighting
figure(1);
surf(x,y,d);light;shading interp;lighting phong;axis tight;xlabel(xname);ylabel(yname); 
%                                     to add colorbar uncomment:
%colorbar;





